/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  menu.h
//  Functions for the menu
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef MENU_H
#define MENU_H

// status of the switch to control the menu
extern volatile unsigned int key_enter_short, key_plus_short, key_minus_short, key_esc_short;


// global variable to select configuration mode or information mode
extern volatile unsigned int menu_config;

// global variables to store the temperatures in degrees
//extern volatile unsigned int temp_hbridge, temp_chassis, temp_pfc;

// global variables to store the output voltage and current
extern volatile unsigned int voltage_output, current_output;

// global variables to store the output power
extern volatile unsigned long output_power;

// global variables to store the input current
extern volatile unsigned long input_current;

// global variables to store the mains and the pfc voltage
extern volatile unsigned int voltage_mains, voltage_pfc;

// global variable for setting the reference voltage;
//extern volatile signed int ref_voltage;

// global variables for setting the switching frequency
//extern volatile unsigned int threshold0_fswitch;

// global variable to store the state (OFF/stand-by/pre-charge/charging) of the power supply
extern volatile unsigned int status_supply;

// global variable to store the state of the "Battery charger enabled"
extern volatile unsigned int charge_enabled;

// global variable to store the state of the "Master / Slave configuration, master_slave = 10 -> Only the master is present;
// 																			master_slave < 10 means: one master + (10 - master_slave) slaves (master_slave=8 means: one master + 2 slaves);
//																			master_slaves > 10  means: one master + master_slave - 10) slaves;
extern volatile unsigned int master_slave;

// global variable to store the state of the "Type of Battery, Lead Acid = 0, Gel = 1"
extern volatile unsigned int battery_type;

// global variable to store the state of the Trickle charge voltage level
extern volatile unsigned int trickle_voltage;

// global variable to store the state of the Float voltage level
extern volatile unsigned int float_voltage;

// global variable to store the state of the Minimum charge voltage level
extern volatile unsigned int minimum_voltage;

// global variable to store the state of the maximum output current
extern volatile unsigned int current_limit;

// global variable to store the state of the maximum output power
extern volatile unsigned int power_limit;

// global variable to store the state of the Minimum current to enter trickle charge
extern volatile unsigned int minimum_current_trickle;

// global variable to store the state of the Minimum mains AC voltage
extern volatile unsigned int mains_uvlo;

// global variable to store the state of the Maximum mains AC voltage
extern volatile unsigned int mains_ovv;

// global variable to store the state of compensation coefficient for Vout as function of battery temperature
extern volatile unsigned int temperature_coefficient;

// global variable to store the state of compensation coefficient for Vout as function of battery temperature
extern volatile unsigned int overtemperature_protection;
//extern volatile unsigned int test;

// global variable to store the state of compensation coefficient for Vout as function of battery temperature
extern volatile unsigned int backlight;

extern volatile unsigned int menu_modify;

// global variable to store the state of the whole battery charger:
// 0=OFF, 1=finished precharge PFC caps -> relay ON, 2=PFC stage ON, 3=connect output terminals (precharge output caps)
// 4=output caps precharge completed, 5=DC/DC ON
extern volatile unsigned int status_charger;

// global variable to indicate that there is an alarm; alarm=0 -> no alarm
// bit0 => Mains UVLO, bit1 => Mains OVV, bit2 => Output overvoltage, bit3 => Output Shorted, bit4 => Overtemperature 1
// bit5 => Overtemperature 2, bit6 => Fan Failure, bit7 => DC/DC Failure
extern volatile unsigned int alarm, warning, voltage_ac, temperature_plus_50;

/* This function shows the selected information on the display.
 * 1: show output voltage & output current
 * 2: show mains voltage & PFC voltage
 * 3: show switching frequency
 * 4: show heatsink temperature of PFC & Hbridge
 * 5: show chassis temperature */
void show_info(unsigned int selection);

void print_parameter(unsigned int parameter, unsigned int position, unsigned int line);

void delete_second_raw (void);

// This function checks if all parameters are within range.
// If a fault is present, the word "alarm" will be > 0.
void check_status(void);

#endif /*MENU_H*/
